/* eslint-disable no-restricted-syntax */
/** @format */

const mongoose = require('mongoose');

const { convert } = require('joigoose')(mongoose);
const Joi = require('joi');
const baseSchema = require('../../../baseSchema');

const chatJoigooseSchema = Joi.object({
  participants: Joi.array().items(Joi.string().meta({
    _mongoose: { type: 'ObjectId', ref: 'User' }
  })).min(2).max(2).required(),
  lastMessage: Joi.string().meta({
    _mongoose: { type: 'ObjectId', ref: 'Message' }
  }).optional(),
  isRequest: Joi.boolean().default(true),
  accepted: Joi.boolean().optional(),
  ...baseSchema
});

let chatSchema = convert(chatJoigooseSchema);

chatSchema.participants = [{
  type: mongoose.Schema.Types.ObjectId,
  ref: 'User'
}];


chatSchema = new mongoose.Schema(chatSchema);


const Chat = mongoose.model('Chat', chatSchema);

// validate the chat input by passing it to joigoose schema
const validateChat = chatData => chatJoigooseSchema.validate(chatData);

module.exports = {
  Chat,
  validateChat
};
