/** @format */

const { routesHandler } = require('../../../../helpers/util-generic-functions');
const {
  createChat,
  getAllChats,
  getChat,
  updateChat,
  deleteChat
} = require('../controller/chat');
const { protect } = require('../../../../middleware/authenticationMiddleware');

const post = router => {
  // Post Routes
  router.post(`/chat/create`, protect, routesHandler(createChat));
  router.get(`/chats`, protect, routesHandler(getAllChats));
  router.get(`/chat/:id`, protect, routesHandler(getChat));
  router.put(`/chat/:id`, protect, routesHandler(updateChat));
  router.put(`/chat/delete/:id`, protect, routesHandler(deleteChat));

};

module.exports = post;
