/* eslint-disable no-restricted-syntax */
/** @format */

const mongoose = require('mongoose');

const { convert } = require('joigoose')(mongoose);
const Joi = require('joi');
const baseSchema = require('../../baseSchema');

const postJoigooseSchema = Joi.object({
  user: Joi.string()
    .required(),
  caption: Joi.string()
    .optional()
    .max(2200),
  media: Joi.array()
    .items(Joi.object({
      type: Joi.string(),
      size: Joi.number(),
      filename: Joi.string(),
      url: Joi.string()
    })),
  location: Joi.object({
    country: Joi.string().allow(''),
    city: Joi.string().allow(''),
    state: Joi.string().allow(''),
    postalCode: Joi.string().allow(''),
    address: Joi.string().allow('')
  }),
  tags: Joi.array()
    .items(Joi.string()),
  ...baseSchema
});

let postSchema = convert(postJoigooseSchema);

postSchema.tags = [{
  type: mongoose.Schema.Types.ObjectId,
  ref: 'User'
}];
postSchema.user = {
  type: mongoose.Schema.Types.ObjectId,
  ref: 'User'
};


postSchema = new mongoose.Schema(postSchema);


const Post = mongoose.model('Post', postSchema);

// validate the post input by passing it to joigoose schema
const validatePost = postData => postJoigooseSchema.validate(postData);

module.exports = {
  Post,
  validatePost
};
