/** @format */
/** @format */
// const jwt = require('jsonwebtoken');
const crypto = require('crypto');
const config = require('@root/config');
const { ObjectId } = require('mongoose').Types;
// const { promisify } = require('util');
const { cacheInstance, removeSession } = require('@helpers/util-Cache');
const { generateJWTToken } = require("@helpers/util-utilities");
const {
  createDoc,
  getDocs,
  updateDoc,
  deleteDoc
} = require('@helpers/factoryFN');
const { validateUser, User } = require('../model/user');
const { _responseWrapper, _res } = require('@helpers/util-response');
const { sendEmail, isValidEmail } = require('../../../utils/email');
const {
  baseUrlGenerator
} = require('@middleware/fileUploadMiddleware');
const _ = require('lodash');
const { validTokenStr } = require('../../../middleware/authenticationMiddleware');



// get all users Routes
exports.getUser = async req => {
  return await getDocs(User)(req);
};

exports.updateUser = async req => {
  if (req.file) req.body.avatar = baseUrlGenerator(req);

  return updateDoc(User)(req);
};

exports.getAllUsers = async req => getDocs(User)(req);
exports.deleteUser = deleteDoc(User);

exports.signup = async req => {
  try {
    if (req.file) req.body.avatar = baseUrlGenerator(req);

    const user = await createDoc(User, {
      returnDoc: true,
      validateFN: validateUser
    })(req);

    if (!user.status && user.error && user.error.code === 11000)
      return _responseWrapper(true, 'User is already exist.', 400)

    if (!user.status) {
      if (user.statusCode === 400)
        return user
      return _responseWrapper(true, user.error.message, 400);
    }

    return _responseWrapper(false, 'User has been created', 201, {
      data: user.data
    });
  } catch (error) {
    console.log('error', error.message);
  }
};

exports.login = async req => {
  try {

    if (req.body.email) {
      req.body.email = req.body.email.toLowerCase();
    }

    // 1) Validate the user data
    const { email, password } = req.body;
    if (!(email) || !password) return _responseWrapper(true, 'requiredAll', 400);

    if (!isValidEmail(email)) return _responseWrapper(true, 'emailErr', 400);


    const query = { email }

    const restParams = {
      query,
      findMethod: 'FindOneWithRefs',
      returnDoc: true,
      select: '+password',
    };
    const { data: user, status } = await getDocs(User, restParams)(req);
    if (!status) return _responseWrapper(true, 'something went wrong', 404);

    if (!user)
      return _responseWrapper(true, 'email or password are incorrect', 404);


    //3) Verify its password by db hash password
    const verifyPwd = await user.verifyPassword(password, user.password);
    if (!verifyPwd)
      return _responseWrapper(true, 'email or password are incorrect', 400);

    // 4) generate the token for the user
    const token = await generateJWTToken(user);


    user['password'] = undefined;
    user['isDeleted'] = undefined;
    user['__v'] = undefined;

    // 5) If the above steps, passed successfully, the send the token
    return _responseWrapper(false, 'login success', 200, {
      data: { token, user }
    });
  } catch (e) {
    console.log("error", e)
    return _responseWrapper(true, e.message, 500);
  }
};

exports.logout = async req => {
  let apiToken = req.headers["authorization"];
  if (apiToken) {
    await removeSession(
      cacheInstance["session-cache"],
      validTokenStr(apiToken)
    );
    return _responseWrapper(true, "Logout successfully", 200);
  } else return _responseWrapper(false, "Authorization token is required", 401);
}


exports.forgotPassword = async req => {
  let user;
  try {
    const { email } = req.body;

    // find and validate the user
    user = await getDocs(User, {
      query: { email },
      findMethod: 'FindOne',
      returnDoc: true
    })(req);
    if (!user.status)
      return _responseWrapper(true, 'Something went wrong', 500);
    if (!user.data)
      return _responseWrapper(
        true,
        'invalid email, Please provide an valid email',
        500
      );

    const pwdResetToken = await user.data.generatePwdResetToken();
    await user.data.save({ validateBeforeSave: false });

    // email configuration
    const subject = 'Password Reset link (valid for next 20 minutes)';
    const url = `url/reset-password/${pwdResetToken}`;
    const text = `You can reset your password by clicking on the link below ${url} if you have not forget your password then please ignore it`;

    // sending email
    await sendEmail({
      to: email,
      subject,
      text
    });

    return _responseWrapper(false, 'Email sent successfully', 200);
  } catch (e) {
    console.log(e);
    user.passwordResetToken = undefined;
    user.passwordResetExpires = undefined;
    await user.save({ validateBeforeSave: false });
    return _responseWrapper(true, e.message, 400);
  }
};

exports.resetPassword = async req => {
  try {
    const { token } = req.params;
    const { newPassword, confirmPassword } = req.body;

    const encryptedToken = crypto
      .createHash('sha256')
      .update(token)
      .digest('hex');

    // get user by token
    const { data: user, status } = await getDocs(User, {
      query: {
        passwordResetToken: encryptedToken,
        passwordResetExpires: { $gt: Date.now() }
      },
      returnDoc: true,
      findMethod: 'FindOne'
    })(req);

    if (!status) return _responseWrapper(true, 'something went wrong', 400);
    if (!user)
      return _responseWrapper(
        true,
        'invalid token or token has been expired',
        400
      );

    // if user not found so, one case could be happen tha token has been expired, so We need to remove the both field from DB
    if (!user) {
      user.resetPasswordExpired = undefined;
      user.passwordResetToken = undefined;
      return _responseWrapper(
        true,
        'user not found, or token has been expired',
        400
      );
    }
    // set the password and remove the resetPwdToken and expired time from DB
    user.password = newPassword;
    user.confirmPassword = confirmPassword;
    user.resetPasswordExpired = undefined;
    user.passwordResetToken = undefined;
    await user.save();

    return _responseWrapper(
      false,
      'Password has been reset successfully',
      200
    );
  } catch (e) {
    return _responseWrapper(true, e.message, 400);
  }
};



// User Profile Routes
exports.updatePassword = async (req, res) => {
  const { _id } = req.user;
  const { currentPassword, newPassword, confirmNewPassword } = req.body;
  const reqCopy = { ...req, params: { id: _id } };

  const { data: user, status } = await getDocs(User, {
    returnDoc: true,
    select: '+password'
  })(reqCopy);
  if (!status)
    return _responseWrapper(
      true,
      'system does not recognize your identity',
      400
    );

  const verifyPassword = await user.verifyPassword(currentPassword, user.password);


  if (!verifyPassword)
    return _responseWrapper(
      true,
      `Your current password is incorrect`,
      400
    );

  user.password = newPassword;
  user.confirmPassword = confirmNewPassword;

  await user.save();

  const token = await generateJWTToken(user);
  return _responseWrapper(
    false,
    'your password has been changed successfully',
    200,
    { data: { token } }
  );
};
