/* eslint-disable global-require */
/**
 * Created by hassan.Raza on 02/09/2024.
 */
/*--------------------INITIAL SETUP--------------------*/
const dotenv = require('dotenv');
const path = require('path');
dotenv.config({ path: path.join(__dirname, '.env') }); //'./config.env'


/*--------------------INCLUDE PACKAGES--------------------*/
const express = require('express');
const bodyParser = require('body-parser');
const cookieParser = require('cookie-parser');
const logger = require('morgan');
const cache = require('./helpers/util-Cache');
const cors = require('cors');
const helmet = require('helmet');
const compression = require('compression');
const device = require('express-device');
const { restoreCache } = require('./helpers/util-Cache');


const app = express();
const router = express.Router();
const apiVersion = 'v1';

/*--------------------GENERAL MIDDLEWARE--------------------*/
app.use(cors());
app.use(helmet());
app.use(logger('dev'));
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));
app.use(device.capture());
app.use(compression());
app.disable('x-powered-by'); // Disable X-Powered-By to hide express version

/*--------------------BASE ROUTE--------------------*/
app.get('/', (req, res) => {
    res.send('Server is started');
});

/*--------------------MONGOOSE CONNECTION--------------------*/
require('./bin/database');

/*--------------------RESTORE CACHE--------------------*/
restoreCache();

/*--------------------ROUTES CONFIG--------------------*/
app.use(`/${apiVersion}`, router);

// CORS and Headers Setup for API Responses
router.use((req, res, next) => {
    res.header('Access-Control-Allow-Origin', '*');
    res.header('Access-Control-Allow-Credentials', true);
    res.header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, DELETE');
    res.header(
        'Access-Control-Allow-Headers',
        'Authorization, Origin, X-Requested-With, Content-Type, Accept, Cache-Control'
    );

    // Get IP address from the request
    req.userIp = req.headers['x-forwarded-for'] || req.socket.remoteAddress.split(':').pop();
    req.userIp = req.userIp === '127.0.0.1' ? '' : req.userIp;

    next();
});

// Delay to load routes
setTimeout(() => {
    require('./routes/index')(router); // Load the routes
}, 1000);

/*--------------------EXPORT MODULES--------------------*/
module.exports = { apiVersion, app };
