// Requiring uuid configuration
const jwt = require('jsonwebtoken');
const { AUTH } = require('../config');

// create JWT
const generateToken = (jwtObject, expiry) => {
  return jwt.sign(jwtObject, AUTH.jwt.secret, {
    expiresIn: expiry,
    issuer: 'LinkedInk'
  });
};

const verifyToken = token => {
  return jwt.verify(token, AUTH.jwt.secret, {}, (err, decoded) => {
    if (err) return false;
    return decoded;
  });
};

module.exports = {
  generateToken,
  verifyToken
};
